import cv2
import tkinter as tk
from PIL import Image, ImageTk
import threading
import os
import time
import numpy as np


class WebcamCapture:
    def __init__(self, camera_indices):
        self.camera_indices = camera_indices
        self.video_captures = [cv2.VideoCapture(index) for index in camera_indices]
        self.is_capturing = False
        self.recording = False
        self.asana_text = ""

    def start_capture(self):
        self.is_capturing = True
        self.capture_threads = [threading.Thread(target=self._capture_loop, args=(index,))
                               for index in self.camera_indices]

        for capture in self.video_captures:
            # Set the frame rate to 30 fps
            capture.set(cv2.CAP_PROP_FPS, 30)

        for thread in self.capture_threads:
            thread.start()

    def stop_capture(self,asana_entry):
        self.is_capturing = False
        for thread in self.capture_threads:
            thread.join()

        for capture in self.video_captures:
            capture.release()
        

    def toggle_recording(self, recording_state, asana_entry):
        self.recording = not self.recording
        recording_state.set("Stop Recording" if self.recording else "Start Recording")
        print(f"Recording {'started' if self.recording else 'stopped'}")


        if self.recording:

            self.set_asana_text(asana_entry.get())
            webcam.create_directories()
        else:
              
            print('HI')
            pre_imgs = os.listdir(f"{os.getcwd()}/{self.asana_text}")
            img = []
            indexes = []
            
            for i in pre_imgs:
                img1 = []
                indexes1 = []
                if 'cam' in i:
                    for j in os.listdir(f"{os.getcwd()}/{self.asana_text}/{i}"):
                        img1.append(f"{os.getcwd()}/{self.asana_text}/{i}/{j}")
                        indexes1.append(int(j.split("_")[0]))

                    img.append(img1)
                    indexes.append(indexes1)

            for i in range(len(indexes)):
                sorted_data = sorted(zip(indexes[i], img[i]), key=lambda x: x[0])
                indexes[i], img[i] = zip(*sorted_data)
            print(img)            
            print('HI2')
            os.mkdir(f"{os.getcwd()}/{self.asana_text}_vid")


            k = 0
            for j in img:
                cv2_fourcc = cv2.VideoWriter_fourcc(*'mp4v')

                frame = cv2.imread(str(j[0]))
                if frame is None:
                    print(f"Failed to read image from {j[0]}")
                    continue

                size = (frame.shape[1], frame.shape[0])  
                video = cv2.VideoWriter(f"{os.getcwd()}/{self.asana_text}_vid/cam_{k}.mp4", cv2_fourcc, 30, size)
                for i in range(len(j)): 
                
                    frame = cv2.imread(str(j[i]))  

                    if frame is not None:
                        video.write(frame)
                        print('frame ', i+1, ' of ', len(j))
                    else:
                        print(f"Failed to read image from {j[i]}")

                k += 1
                video.release()
                # asana_entry.delete(0, tk.END) # Clear the entry when stopped

    def set_asana_text(self, text):
        self.asana_text = text
    
    def create_directories(self):
        # Create directories for each camera and asana_text
        for index in self.camera_indices:
            os.makedirs(f"{os.getcwd()}/{self.asana_text}/cam_{index}")

    def _capture_loop(self, index):
        i = 0
        frame_interval = 1 / 30
        while self.is_capturing:
            start_time = time.time()
            ret, frame = self.video_captures[index].read()
            if not ret:
                print(f"Failed to capture frame from camera {index}")
                break

            # Resize the frame to fit the section in the GUI
            resized_frame = cv2.resize(frame, (section_width, section_height))

            # Convert the OpenCV BGR frame to RGB format
            rgb_frame = cv2.cvtColor(resized_frame, cv2.COLOR_BGR2RGB)
            img = Image.fromarray(rgb_frame)

            # Update the Tkinter label with the new image
            imgtk = ImageTk.PhotoImage(image=img)
            labels[index].imgtk = imgtk
            labels[index].configure(image=imgtk)

            if self.recording:
                # Save the frame to a file with a meaningful name
                cv2.imwrite(f"{os.getcwd()}/{self.asana_text}/cam_{index}/{i}_{time.time()}.jpg", frame)
                i += 1

            elapsed_time = time.time() - start_time
            wait_time = max(0, frame_interval - elapsed_time)
            time.sleep(wait_time)

            # Press 'q' to exit the loop and stop capturing
            if cv2.waitKey(1) & 0xFF == ord('q'):
                break

        print(f"Capture loop for camera {index} exited")

if __name__ == "__main__":
    # Specify the camera sources (change the values accordingly)
    camera_sources = [0, 1, 2, 3]

    # Specify the initial GUI window size
    initial_width = 800
    initial_height = 600

    # Calculate the section dimensions based on the number of cameras
    num_cameras = len(camera_sources)
    section_width = initial_width // 2
    section_height = initial_height // (num_cameras // 2)

    webcam = WebcamCapture(camera_indices=camera_sources)

    root = tk.Tk()
    root.title("YogaPal Data Collection Tool") 

    labels = []

    for index in range(num_cameras):
        row = index // 2
        col = index % 2
        label = tk.Label(root)
        label.grid(row=row, column=col, padx=10, pady=10)
        labels.append(label)

    recording_state = tk.StringVar()
    recording_state.set("Start Recording", )

    recording_button = tk.Button(root, textvariable=recording_state, command=lambda: webcam.toggle_recording(recording_state, asana_entry), font=("Helvetica", 20))
    recording_button.grid(row=num_cameras // 2, column=1, padx=10, pady=10)

    asana_label = tk.Label(root, text="Yoga Asana:", font=("Helvetica", 20))
    asana_label.grid(row=num_cameras // 2, column=0, pady=10, padx=10,  sticky='sw')

    asana_entry = tk.Entry(root, font=("Helvetica", 20))
    asana_entry.grid(row=num_cameras // 2 + 1, column=0, pady=10, padx=10, sticky='sw')

    webcam.start_capture()

    root.mainloop()

    # Stop capture when the Tkinter window is closed
    webcam.stop_capture(asana_entry)